/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.exoticbirds.client.gui.ScreenBirdBook;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public class PacketSendBirdBiomes {
    private final EntityType entityType;
    private final List<Biome> biomeList;

    public PacketSendBirdBiomes(EntityType entityType, List<Biome> biomeList) {
        this.entityType = entityType;
        this.biomeList = biomeList;
    }

    public static void encode(PacketSendBirdBiomes message, PacketBuffer buffer) {
        ResourceLocation entityName = new ResourceLocation(Registry.field_212629_r.func_177774_c((Object)message.entityType).toString());
        buffer.func_192572_a(entityName);
        buffer.writeInt(message.biomeList.size());
        for (Biome b : message.biomeList) {
            ResourceLocation biomeName = new ResourceLocation(WorldGenRegistries.field_243657_i.func_177774_c((Object)b).toString());
            buffer.func_192572_a(biomeName);
        }
    }

    public static PacketSendBirdBiomes decode(PacketBuffer buffer) {
        ResourceLocation entityName = buffer.func_192575_l();
        Optional entityOpt = Registry.field_212629_r.func_241873_b(entityName);
        EntityType entityType = (EntityType)ExoticBirdsEntities.BIRD_EGG.get();
        if (entityOpt.isPresent()) {
            entityType = (EntityType)entityOpt.get();
        }
        int biomeListSize = buffer.readInt();
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        for (int i = 0; i < biomeListSize; ++i) {
            ResourceLocation biomeName = buffer.func_192575_l();
            Optional biomeOpt = WorldGenRegistries.field_243657_i.func_241873_b(biomeName);
            if (!biomeOpt.isPresent()) continue;
            biomeList.add((Biome)biomeOpt.get());
        }
        return new PacketSendBirdBiomes(entityType, biomeList);
    }

    public static void handle(PacketSendBirdBiomes packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSendBirdBiomes.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketSendBirdBiomes packet) {
        if (packet.entityType == ExoticBirdsEntities.BIRD_EGG.get()) {
            return;
        }
        ScreenBirdBook.birdBiomes.add(new AbstractMap.SimpleEntry<EntityType, List<Biome>>(packet.entityType, packet.biomeList));
    }
}

